import javax.swing.UIManager;
import java.awt.*;

import java.awt.image.*;
import java.awt.event.*;
import java.awt.image.renderable.*;
import javax.swing.*;

import javax.media.jai.*;
import javax.media.jai.operator.*;
import javax.media.jai.widget.*;
import trex.*;

/**
 * <p>Title: TRex - Steganography</p>
 * <p>Description: TRex is a demonstration program for steganography alghorithms</p>
 * <p>Copyright: Copyright (c) 2001</p>
 * <p>Company: University of Freiburg, Germany</p>
 * @author Bastian Friedrich
 * @version 1.0
 */

class TransformFrame extends JFrame {
  JPanel contentPane;
  JPanel jPanel1 = new JPanel();
  JPanel jPanel2 = new JPanel();
  GridLayout gridLayout1 = new GridLayout();
  JLabel jLabel1 = new JLabel();
  JLabel jLabel2 = new JLabel();
  JPanel jPanel4 = new JPanel();
  JPanel jPanel3 = new JPanel();
  JLabel jLabel3 = new JLabel();
  JLabel jLabel4 = new JLabel();

  ImageIcon imgSrc;
  ImageIcon imgDst;
  ImageIcon imgBack;

  String filename;

  //Den Frame konstruieren
  public TransformFrame(String filename) {
    enableEvents(AWTEvent.WINDOW_EVENT_MASK);
    this.filename = filename;
    try {
      jbInit();
    }
    catch(Exception e) {
      e.printStackTrace();
    }
  }

  private PlanarImage FormatTransformed(PlanarImage src, PlanarImage template) {
    // Create a RenderingHints object with desirable layout.
    ImageLayout il = new ImageLayout();
    il.setSampleModel(template.getSampleModel());
    il.setColorModel(template.getColorModel());
    RenderingHints rh = new RenderingHints(JAI.KEY_IMAGE_LAYOUT, il);

    // Convert the data to byte.
    ParameterBlock pb = new ParameterBlock();
    pb.addSource(src);
    pb.add(DataBuffer.TYPE_BYTE);
    PlanarImage dst = JAI.create("format", pb, rh);

    return dst;
  }

  private void createDFT() {

    PlanarImage src = JAI.create("fileload", filename);

    imgSrc.setImage(FormatTransformed(src, src).getAsBufferedImage());

    PlanarImage dft = JAI.create("dft", src);

    imgDst.setImage(FormatTransformed(dft, src).getAsBufferedImage());

    PlanarImage idft = JAI.create("idft", dft);

    imgBack.setImage(FormatTransformed(idft, src).getAsBufferedImage());
  }


  //Initialisierung der Komponenten
  private void jbInit() throws Exception  {
    //setIconImage(Toolkit.getDefaultToolkit().createImage(TransformFrame.class.getResource("[Ihr Symbol]")));
    contentPane = (JPanel) this.getContentPane();
    contentPane.setLayout(gridLayout1);
    this.setSize(new Dimension(600, 600));
    this.setTitle("TransformTest");

    gridLayout1.setColumns(2);
    gridLayout1.setRows(2);
    jLabel4.setText("Done!");
    contentPane.add(jPanel1, null);
    contentPane.add(jPanel2, null);
    contentPane.add(jPanel3, null);
    jPanel3.add(jLabel3, null);
    contentPane.add(jPanel4, null);
    jPanel4.add(jLabel4, null);

    jPanel1.add(jLabel1, null);
    jPanel2.add(jLabel2, null);

    imgSrc = new ImageIcon();
    imgDst = new ImageIcon();
    imgBack = new ImageIcon();

    jLabel1.setIcon(imgSrc);
    jLabel2.setIcon(imgDst);
    jLabel3.setIcon(imgBack);

    createDFT();

  }
  //berschrieben, so da eine Beendigung beim Schlieen des Fensters mglich ist.
  protected void processWindowEvent(WindowEvent e) {
    super.processWindowEvent(e);
    if (e.getID() == WindowEvent.WINDOW_CLOSING) {
      System.exit(0);
    }
  }
}



public class TransformTest {
  boolean packFrame = false;

  static String filename;


  //Die Anwendung konstruieren
  public TransformTest() {
    TransformFrame frame = new TransformFrame(filename);
    //Frames berprfen, die voreingestellte Gre haben
    //Frames packen, die nutzbare bevorzugte Greninformationen enthalten, z.B. aus ihrem Layout
    if (packFrame) {
      frame.pack();
    }
    else {
      frame.validate();
    }
    //Das Fenster zentrieren
    Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
    Dimension frameSize = frame.getSize();
    if (frameSize.height > screenSize.height) {
      frameSize.height = screenSize.height;
    }
    if (frameSize.width > screenSize.width) {
      frameSize.width = screenSize.width;
    }
    frame.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
    frame.setVisible(true);
  }
  //Main-Methode
  public static void main(String[] args) {
    if (args.length > 0) {
      filename = args[0];
    } else {
      System.out.println("No filename!");
      System.exit(-1);
    }


    try {
      UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
    }
    catch(Exception e) {
      e.printStackTrace();
    }
    new TransformTest();
  }
}
