/*****************************************************************************
 $Id: SimpleTextEditor.java,v 1.9 2002/04/14 03:42:33 bastian Exp $
 Part of TRex, (c) 2001, 2002 Bastian Friedrich <bastian@bastian-friedrich.de>
 This software licensed under the GPL.
 *****************************************************************************/
package trex.GUI;

import java.awt.*;
import javax.swing.*;
import java.awt.event.*;

/**
 * This is a simple text editor window.
 * @author Bastian Friedrich <a href="mailto:bastian@bastian-friedrich.de">&lt;bastian@bastian-friedrich.de&gt;</a>
 * @version $Revision: 1.9 $
 */

public class SimpleTextEditor extends JDialog {
  BorderLayout borderLayout1 = new BorderLayout();
  JButton jButtonOK = new JButton();

  String data = new String();
  boolean okPressed;
  JScrollPane jScrollPane1 = new JScrollPane();
  JTextArea jTextArea = new JTextArea();

  /**
   * Display a window to edit the text.
   * As a static method, it can be called as <code>
   * String newString = SimpleTextEditor.modifyText(this, "pre-set text");
   * @param parent Parent frame
   * @param ori pre-set text.
   * @return The edited text.
   */
  public static String modifyText(JFrame parent, String ori) {
    // create a new dialog and pre-set text.
    SimpleTextEditor editor = new SimpleTextEditor();
    editor.jTextArea.setText(ori);

    // initialize dialog geometry
    Dimension dlgSize = new Dimension(600,300);
    Dimension frmSize = parent.getSize();
    Point loc = parent.getLocation();
    editor.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
    editor.setSize(dlgSize);

    // display modal dialog and return data.
    editor.show();
    if (editor.okPressed)
      return editor.data;
    else
      return ori;  // if window is closed by something else than "OK" button
  }
  /**
   * Boring default constructor.
   */
  private SimpleTextEditor() {
    okPressed = false;
    try {
      jbInit();
    }
    catch(Exception e) {
      e.printStackTrace();
    }
  }

  /**
   * Construct components.
   */
  private void jbInit() throws Exception {

    this.setModal(true);
    this.setTitle("Edit...");
    jButtonOK.setText("OK");
    jButtonOK.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        jButtonOK_actionPerformed(e);
      }
    });
    this.getContentPane().setLayout(borderLayout1);
    this.getContentPane().add(jButtonOK, BorderLayout.SOUTH);
    this.getContentPane().add(jScrollPane1, BorderLayout.CENTER);
    jScrollPane1.getViewport().add(jTextArea, null);
  }

  /**
   * Close on "OK"-Button action.
   */
  void jButtonOK_actionPerformed(ActionEvent e) {
    okPressed = true;
    this.data = jTextArea.getText();
    dispose();
  }
}