/*****************************************************************************
 $Id: ImageFileView.java,v 1.7 2002/04/08 12:09:44 bastian Exp $
 Part of TRex, (c) 2001, 2002 Bastian Friedrich <bastian@bastian-friedrich.de>
 This software licensed under the GPL.
 *****************************************************************************/
package trex.GUI.ImageChooser;

import java.io.File;
import javax.swing.*;
import javax.swing.filechooser.*;

/**
 * This class implements a file view for application's "load" and "save"
 * dialogs. It connects gif, jpg and png files. Please note that png is
 * the preferred file format for saving images, as gif is only 8bit color
 * depth and jpg is lossy.
 * <p>This class was mostly stolen from Sun's documentation:
 * <a href="http://java.sun.com/docs/books/tutorial/uiswing/components/filechooser.html">FileChooser
 * Demo</a> (whoops... does this hurt GPL?!)</p>
 * @author Bastian Friedrich <a href="mailto:bastian@bastian-friedrich.de">&lt;bastian@bastian-friedrich.de&gt;</a>
 * @version $Revision: 1.7 $
 */
public class ImageFileView extends FileView {
    ImageIcon jpgIcon = new ImageIcon(ImageFileView.class.getResource("jpgIcon.gif"));
    ImageIcon gifIcon = new ImageIcon(ImageFileView.class.getResource("gifIcon.gif"));
    ImageIcon pngIcon = new ImageIcon(ImageFileView.class.getResource("pngIcon.gif"));

    /**
     * Return file's name.
     * Unneeded - returning null.
     * @param f file.
     * @return null.
     */
    public String getName(File f) {
        return null; // let the L&F FileView figure this out
    }

    /**
     * Return a description for the file.
     * Unneeded - returning null.
     * @param f file.
     * @return null.
     */
    public String getDescription(File f) {
        return null; // let the L&F FileView figure this out
    }

    /**
     * Whether this directory is traversable.
     * Let the GUI identify this.
     * @param f file
     * @return null.
     */
    public Boolean isTraversable(File f) {
        return null; // let the L&F FileView figure this out
    }

    /**
     * Return a description for the file type.
     * A description is derived from the suffix,
     * plainly identifying the file type.
     * @param f file to return type description for
     * @return A file description derived from file suffix.
     */
    public String getTypeDescription(File f) {
        String extension = ImageChooserUtils.getExtension(f);
        String type = null;

        if (extension != null) {
            if (extension.equals(ImageChooserUtils.jpeg) ||
                extension.equals(ImageChooserUtils.jpg)) {
                type = "JPEG Image";
            } else if (extension.equals(ImageChooserUtils.gif)) {
                type = "GIF Image";
            } else if (extension.equals(ImageChooserUtils.jpg)) {
                type = "PNG Image";
            }
        }
        return type;
    }

    /**
     * Return an icon for the file.
     * The icon is plainly chosen according to file's suffix.
     * @param f file to return an icon for
     * @return Icon derived from file suffix.
     */
    public Icon getIcon(File f) {
        String extension = ImageChooserUtils.getExtension(f);
        Icon icon = null;

        if (extension != null) {
            if (extension.equals(ImageChooserUtils.jpeg) ||
                extension.equals(ImageChooserUtils.jpg)) {
                icon = jpgIcon;
            } else if (extension.equals(ImageChooserUtils.gif)) {
                icon = gifIcon;
            } else if (extension.equals(ImageChooserUtils.png)) {
                icon = pngIcon;
            }
        }
        return icon;
    }
}
