/*****************************************************************************
 $Id: DataPanel.java,v 1.13 2002/04/26 22:43:32 bastian Exp $
 Part of TRex, (c) 2001, 2002 Bastian Friedrich <bastian@bastian-friedrich.de>
 This software licensed under the GPL.
 *****************************************************************************/
package trex.GUI;

import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
import java.io.*;

import trex.*;

/**
 * This class provides a panel for the texts to hide.
 * Text can be loaded and edited with the associated buttons.
 * @author Bastian Friedrich <a href="mailto:bastian@bastian-friedrich.de">&lt;bastian@bastian-friedrich.de&gt;</a>
 * @version $Revision: 1.13 $
 */

public class DataPanel extends JPanel {
  /**
   * Panel's layout.
   */
  BorderLayout borderLayout1 = new BorderLayout();
  /**
   * Toolbar to contain open and edit buttons.
   */
  JToolBar jToolBarDataView = new JToolBar();
  /**
   * Load button.
   */
  JButton jButtonLoadData = new JButton();
  /**
   * Text area to display text in
   */
  /**
   * Edit button.
   */
  JButton jButtonEditData = new JButton();

  /**
   * Data class to send values to.
   */
  StegData myData;
  /**
   * Parent frame.
   */
  JFrame parent;
  JButton jButtonSaveData = new JButton();
  JScrollPane jScrollPaneData = new JScrollPane();
  JTextArea jTextAreaDataView = new JTextArea();

  /**
   * set panel's text.
   * @param text New text.
   */
  public void setText(String text) {
    jTextAreaDataView.setText(text);
    (jScrollPaneData.getHorizontalScrollBar()).setValue(0);
    (jScrollPaneData.getVerticalScrollBar()).setValue(0);
  }

  /**
   * Constructs new Panel.
   * @param parent Parent window.
   * @param data {@link trex.StegData} object to entered text to.
   */
  public DataPanel(JFrame parent, StegData data) {
    myData = data;
    this.parent = parent;

    try {
      jbInit();
    }
    catch(Exception e) {
      e.printStackTrace();
    }
    setText(data.getData());
  }

  /**
   * Initializer function.
   * Sets Layout and toolbar with buttons and text area.
   * Created by jbuilder, so don't touch :)
   */
  private void jbInit() throws Exception {
    this.setLayout(borderLayout1);
    jToolBarDataView.setAlignmentY((float) 0.5);
    jButtonLoadData.setText("Load Data");
    jButtonLoadData.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        jButtonLoadData_actionPerformed(e);
      }
    });
    jButtonEditData.setText("Edit Data");
    jButtonEditData.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        jButtonEditData_actionPerformed(e);
      }
    });
    jButtonSaveData.setText("Save Data");
    jButtonSaveData.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        jButtonSaveData_actionPerformed(e);
      }
    });
    jTextAreaDataView.setEditable(false);
    this.add(jToolBarDataView, BorderLayout.NORTH);
    this.add(jScrollPaneData, BorderLayout.CENTER);
    jScrollPaneData.getViewport().add(jTextAreaDataView, null);
    jToolBarDataView.add(jButtonLoadData, null);
    jToolBarDataView.add(jButtonEditData, null);
    jToolBarDataView.add(jButtonSaveData, null);
  }

  public void loadData(File input) {
    String text = new String();

    // try to create a file reader for selected file
    BufferedReader freader;
    try {
      freader = new BufferedReader(new FileReader(input));
    }
    catch (FileNotFoundException exc) {
      JOptionPane.showMessageDialog(this.parent,
                                    "Error reading file",
                                    "Error",
                                    JOptionPane.ERROR_MESSAGE);
      return;
    }

    boolean eof = false;

    try {
      // read data
      while (!eof) {
        String newline = freader.readLine();
        if (newline == null)
          eof = true;
        else {
          text = text + newline + "\n";
        }
      }
    }
    catch (Exception exc) {
      eof = true;
    }

    // send data to data object
    myData.setData(text);

    setText(text);
  }

  /**
   * Respond to "Load button" events.
   */
  void jButtonLoadData_actionPerformed(ActionEvent e) {

    JFileChooser fc = new JFileChooser();

    int returnVal = fc.showOpenDialog(DataPanel.this);

    // If "OK" was pressed, ...
    if (returnVal == JFileChooser.APPROVE_OPTION) {
      loadData(fc.getSelectedFile());
    }

  }

  /**
   * Respond to "Edit data" button events.
   */
  void jButtonEditData_actionPerformed(ActionEvent e) {
    // create new SimpleTextEditor, get it's text and send it to data object
    setText(SimpleTextEditor.modifyText(parent, jTextAreaDataView.getText()));
    myData.setData(jTextAreaDataView.getText());
  }

  /**
   * Respond to "Save data" button events.
   */
  void jButtonSaveData_actionPerformed(ActionEvent e) {
    JFileChooser fc = new JFileChooser();

    int returnVal = fc.showSaveDialog(DataPanel.this);

    // If "OK" was pressed, ...
    if (returnVal == JFileChooser.APPROVE_OPTION) {
       File f = fc.getSelectedFile();
       String text = myData.getData();

       // try to create a file reader for selected file
       BufferedWriter fwriter;
       try {
         fwriter = new BufferedWriter(new FileWriter(f));
         fwriter.write(text);
         fwriter.close();
       }
       catch (Exception exc) {
         JOptionPane.showMessageDialog(this.parent,
                                       "Error",
                                       "Error writing file",
                                       JOptionPane.ERROR_MESSAGE);
         return;
       }
     }
  }
}