use OpenSER::Message;
use OpenSER::Constants;
use OpenSER::LDAPUtils::LDAPConf;
use OpenSER::LDAPUtils::LDAPConnection;

use OpenSER::Utils::PhoneNumbers;

# 



sub ldapalias {
	my $m = shift;

	my $uri = $m->getRURI();
	$m->log(L_INFO, "RURI is $uri\n");

	$uri =~ s/^sip://;
	$uri =~ s/;.*//;

	$m->log(L_INFO, "cut uri is $uri\n");

	my $ldap = new OpenSER::LDAPUtils::LDAPConnection();

	my @rows = $ldap->search("(&(ObjectClass=inetOrgPerson)(mail=$uri))", "ou=people,dc=coreworks,dc=de", "uid");

	if (@rows) {
		my $newuri = "@rows\@voip";
		$m->log(L_INFO, "new uri is $newuri\n");

		$ret = $m->rewrite_ruri("sip:$newuri");
		
		return 1;
	} else {
		return -1;
	}
}

sub ldapalias2 {
	my $m = shift;

	my $uri = $m->getParsedRURI();
#	$m->log(L_INFO, "RURI is $uri\n");
	my $user = $uri->user();
	my $dom = $uri->host();

	$m->log(L_INFO, "cut uri is $user at $dom\n");

	my $ldap = new OpenSER::LDAPUtils::LDAPConnection();

	my @rows = $ldap->search("(&(ObjectClass=inetOrgPerson)(mail=$user\@$dom))", "ou=people,dc=coreworks,dc=de", "uid");

	if (@rows) {
		my $newuri = "@rows\@voip";
		$m->log(L_INFO, "new uri is $newuri\n");

		$ret = $m->rewrite_ruri("sip:$newuri");
		
		return 1;
	} else {
		return -1;
	}
}

sub ldaptelephone {
	my $m = shift;

	my $uri = $m->getRURI();
	$m->log(L_INFO, "RURI is $uri\n");

	if ($uri =~ m/^sip:\+?[0-9]+\@/ ) {
		$m->log(L_INFO, "I've got a telephone number here.\n");

		$uri =~ s/^sip://;
		$uri =~ s/;.*//;
		$uri =~ s/\@.*//;

		$m->log(L_INFO, "number is $uri\n");

		my $ldap = new OpenSER::LDAPUtils::LDAPConnection();
		@rows = $ldap->search("(&(ObjectClass=inetOrgPerson)(telephonenumber=$uri))", "ou=people,dc=coreworks,dc=de", "uid");

		if (@rows) {
			my $newuri = "@rows\@voip";
			$m->log(L_INFO, "new uri is $newuri\n");

			$ret = $m->rewrite_ruri("sip:$newuri");

			return 1;
		}

	}

	return -1;

}


# Try to fetch full name from LDAP
sub ldapreversetest {
	my $m = shift;

	my $retval = -1;


	if ($m->getMethod() eq "INVITE") {
		my $from = $m->getHeader("From");
		my $user;
		my $host;
		if ($from =~ m/.*<sip:(.*)@(.*)>/) {
			($user, $host) = ($1, $2);
		}

		$m->log(L_INFO, "From was: '$from' - addr is '$user (at) $host'");

		my $p = new OpenSER::Utils::PhoneNumbers(publicAccessPrefix => "0",
	        	                                 internationalPrefix => "+",
							 longDistancePrefix => "0",
							 countryCode => "49",
							 areaCode => "761",
							 pbxCode => "456842");

		$num = $p->canonicalForm($user);

		if ($num) {

			my $ldap = new OpenSER::LDAPUtils::LDAPConnection();
			@rows = $ldap->search("(&(ObjectClass=inetOrgPerson)(telephonenumber=$num))", "ou=people,dc=coreworks,dc=de", "cn");

			if ($newfn = @rows[0]) {
				$m->log(L_INFO, "found a candidate: $newfn");
				my $newfrom = "\"$newfn\" <sip:$user\@$host>";
				$m->log(L_INFO, "Setting new from '$newfrom'");

				$m->remove_hf("From");
				$m->append_hf("From: $newfrom\n", "To");
				$retval = 1;
			}
		}
	}
	
	return $retval;

}

